dofile('./Scripts/UI/initGUI.lua')

local base = _G

module('autobriefingutils')

local type        = base.type
local require = base.require
local print = base.print
local assert = base.assert
local tostring = base.tostring
local pairs = base.pairs
local ipairs = base.ipairs
local tonumber = base.tonumber
local table = base.table
local math = base.math
local string = base.string

local Tools 					= require('tools')
local Static 					= require('Static')
local i18n 						= require('i18n')
local Grid                      = require('Grid')
local GridHeaderCell            = require('GridHeaderCell')
local Skin                      = require('Skin')
local EditBox			        = require('EditBox')

i18n.setup(_M)

staticSectionItemSkin = Skin.staticSkinSectionItem()
staticSectionDataItemSkin = Skin.staticSkinSectionDataItem()
editBoxSectionDataItemSkin = Skin.editBoxSkinSectionDataItem()
staticTitleItemSkin = Skin.staticSkinTitleItem()
staticGridCellSkin = Skin.staticSkinGridCellBriefing()

local cdata =
{
    NA = _('N/A'),
}

function setData(a_autoBriefing)
    autoBriefing = a_autoBriefing
end 

function isLeapYear(year)
    local result = 0
    --  ,    4      100,
    --  400.    ,     4, 
    --  100    400.
    if (((year%4) == 0) and (((year%100) ~= 0) or ((year%400) == 0))) then
        result = 1
    end
    
    return result;
end

local function createSectionItem_(scrollPane, itemText, x, y, w, h)
    local item = Static.new(itemText)

    item:setSkin(staticSectionItemSkin)    
    item:setBounds(x, y, w, h)
    scrollPane:insertWidget(item)
end

local function createSectionDataItem_(scrollPane, itemText, x, y)
    local item = EditBox.new(itemText)
    local wrapWidth = 520 
    local wrapHeight = 1
    item:setBounds(0, 0, wrapWidth, wrapHeight)
    item:setTextWrapping(true)  
	item:setMultiline(true)
    item:setReadOnly(true)
    
    item:setSkin(editBoxSectionDataItemSkin)

    local w, h = item:calcSize()
    local result
    
    if h <= 1 then 
        w = 133
        h = 27
        result = h
    else
      local sectionDataGap = 8
      
      result = h + sectionDataGap
    end
                  
    item:setBounds(x, y, w, h)

    scrollPane:insertWidget(item)
    
    return result
end

local function createTitleItem_(scrollPane, itemText, x, y, h)
    local item = Static.new(itemText)
    
    item:setSkin(staticTitleItemSkin)
    
    local w = item:calcSize()
   
    item:setBounds(x, y, w, h)
    scrollPane:insertWidget(item)
end

local function createDataItem_(scrollPane, itemText, x, y, h)
    local item = EditBox.new(itemText)
    local w = 347
    item:setBounds(0, 0, w, h)
    item:setTextWrapping(true)  
	item:setMultiline(true)
    item:setReadOnly(true)
    
    item:setSkin(editBoxSectionDataItemSkin)
    
    local _tmp, h1 = item:calcSize()
    
    h1 = math.max(h, h1)
    
    item:setBounds(x, y, w, h1)
    scrollPane:insertWidget(item)
    
    return h1
end

local function createSectionGrid_(a_scrollPane, a_data, a_x, a_y) 
    grid = Grid.new()
    grid:setSkin(Skin.gridSkin_briefing())
    --grid:setFixedColumnCount(3)
    grid:insertColumn(181)
    local headerCell = GridHeaderCell.new(_('Group name'))
    headerCell:setSkin(Skin.grid_header_cell_Briefing())
    headerCell:setBounds(1, 0, 180, 27)
    grid:setColumnHeader(0, headerCell)
    
    grid:insertColumn(181)
    headerCell = GridHeaderCell.new(_('AB/FARP'))
    headerCell:setSkin(Skin.grid_header_cell_Briefing())
    headerCell:setBounds(1, 0, 180, 27)
    grid:setColumnHeader(1, headerCell)
    
    grid:insertColumn(153)
    headerCell = GridHeaderCell.new(_('Frequency'))
    headerCell:setSkin(Skin.grid_header_cell_Briefing())
    headerCell:setBounds(1, 0, 149, 27)
    grid:setColumnHeader(2, headerCell)
    

    local hGrid = 31    
    local rowIndex = 0
    local rowHeight = 27
        
    for k, v in pairs(a_data) do 
        
        local _tmp, h1, h2, h3
        
        local cellGroupName
        cellGroupName = Static.new()
        cellGroupName:setSkin(staticGridCellSkin)  
        cellGroupName:setText(v.name)   
        cellGroupName:setBounds(0, 0, 180, 27)
        _tmp, h1 = cellGroupName:calcSize()         
                
        local cellAirdrom
        cellAirdrom = Static.new()
        cellAirdrom:setSkin(staticGridCellSkin)
        cellAirdrom:setText(v.airdromeName)
        cellAirdrom:setBounds(0, 0, 180, 27)
        _tmp, h2 = cellAirdrom:calcSize()   
                
        local cellFreq
        cellFreq = Static.new()
        cellFreq:setSkin(staticGridCellSkin)
        cellFreq:setText(v.frequency.." ".._('MHz')) 
        cellFreq:setBounds(0, 0, 149, 27)
        _tmp, h3 = cellFreq:calcSize()   
 
        rowHeight = base.math.max(h1, base.math.max(h2,h3))
        
        grid:insertRow(rowHeight) 
        grid:setCell(0, rowIndex, cellGroupName)
        grid:setCell(1, rowIndex, cellAirdrom)
        grid:setCell(2, rowIndex, cellFreq)

        rowIndex = rowIndex + 1
        hGrid = hGrid + rowHeight+1
    end
        
    grid:setBounds(a_x, a_y, 516, hGrid)
    a_scrollPane:insertWidget(grid)
    a_scrollPane:updateWidgetsBounds()
end

-------------------------------------------------------------------------------
--   
function updateScrollPane(scrollPane)
    local rowPos = 17
    local rowHeight = 27
    local tabPos = 32
    local columnPos = 171
    local sectionX = 32
    local sectionWidth = 520
    local sectionHeight = rowHeight + 17
    local sectionOffset = 37
    
    scrollPane:clear()
    
    for i = 1, #autoBriefing do
        local rec = autoBriefing[i]     
        
        if rec.section then --  -  .    
            if i > 1 then
                rowPos = rowPos + sectionOffset  
            end
            createSectionItem_(scrollPane, rec.section, sectionX, rowPos, sectionWidth, sectionHeight)
            rowPos = rowPos + sectionHeight
            
            if rec.data then --     
                local itemHeight = createSectionDataItem_(scrollPane, rec.data, tabPos, rowPos)
                
                rowPos = rowPos + itemHeight
            end
        elseif (not rec.section) and rec.title then --       
            createTitleItem_(scrollPane, rec.title, tabPos, rowPos, rowHeight)
            
            if rec.data then
                local data = {}
                
                if base.type(rec.data) == 'table' then
                    data = rec.data
                else 
                    data[1] = rec.data
                end
                
                for i =1, #data do
                    local itemHeight = createDataItem_(scrollPane, data[i], columnPos, rowPos, rowHeight)
                    
                    rowPos = rowPos + itemHeight
                end
                if #data < 1 then
                    rowPos = rowPos + rowHeight
                end
            else
                rowPos = rowPos + rowHeight
            end 
        elseif rec.needGrid == true then
            base.print("-----ffff-----")
            local itemHeight = createSectionGrid_(scrollPane, rec.data, tabPos, rowPos)    
        end
        
    end
end


-------------------------------------------------------------------------------
--    
--     ,    ,  ,
--   
--     
--   multiplier  - 
function composeString(list, multiplier)
    multiplier = multiplier or ' '
    local str = {}
    if base.next(list) then
        for k,v in pairs(list) do
            table.insert(str, "'" ..tostring(k) .."'" .. multiplier .. tostring(v))
        end
        return str
    else
        return cdata.NA
    end
end

-------------------------------------------------------------------------------
--   \   hh:mm:ss
--    include_date,     ddd/hh:mm:ss
function composeDateString(start_time, include_date, MissionDate)
	local data = convertDaysToData(math.floor(start_time/(60*60*24)), MissionDate)
    --    
    local d = math.floor(start_time / (60*60*24))
    start_time = start_time - d * 60*60*24
    local h = math.floor(start_time / (60*60))
    start_time = start_time - h * 60*60
    local m = math.floor(start_time / 60)
    local s = math.floor(start_time - m * 60)
    local res = ''
    if include_date then
        res = data..'  '--string.format('%03d', d) .. '/'
    end
    return res .. num2s2(h) .. ':' .. num2s2(m) .. ':' .. num2s2(s)
end

-------------------------------------------------------------------------------
-- convert number to string using %02d format string
function num2s2(num)
    return string.format('%02d', num)
end

function convertDaysToData(a_days, MissionDate)

	local NumDayInMounts =
	{
		31, --
		28, --
		31,	--
		30,	--
		31,	--
		30,	--
		31,	--
		31,	--
		30,	--
		31,	--
		30,	--
		31	--
	}
    
    if MissionDate == nil then
        MissionDate = { Year = 2011, Month = 6, Day = 01 }
    end
	
	--     
	local day	= MissionDate.Day 
	local month	= MissionDate.Month  
	local year 	= MissionDate.Year
	
	local tmpData = 0
	
	while true do
		local tmp = tmpData + NumDayInMounts[month] 
		if (month == 2) then
			tmp = tmp + isLeapYear(year)
		end
		
		if (a_days >= tmp) then
			tmpData = tmp
		else
			day = day + a_days - tmpData
			break
		end

		if (month == 12) then		
			month = 1
			year = year + 1
			day = 1
		else
			month = month + 1
			day = 1
		end 
	end
	
	local result = tostring(day)..'/'..tostring(month)..'/'..tostring(year)
	return result
end






--       
function traverseTable(_t, _numLevels, _tabString, filename, filter)
    local _tablesList = {}
    filter = filter or {}
    fun = base.print
    if ( filename and (filename ~= '') ) then
        local out = io.open(filename, 'w')
        fun = function (...)
            out:write(..., '\n')
        end
    end
    function _traverseTable(t, tabString, tablesList, numLevels, filter)
        if (numLevels <1) then 
            return
        end

      for k,v in pairs(t or {} ) do      
            if type(k) == "number" then
                k = '[' .. tostring(k) .. ']'
            end
        if type(v) == "table" then 
            local skip = false
            for i,ignoredField in ipairs(filter) do
                if ignoredField == k then
                    skip = true
                    break
                end
            end
            if skip == false then
                local str = string.gsub(tostring(v), 'table: ','')
                if not tablesList[v] then
                    tablesList[v] = tostring(k)
                    fun(tabString  .. tostring(k) .. "--[[" .. str .. "--]]  = {")
                    --numLevels = numLevels - 1
                    _traverseTable(v, tabString .. '    ', tablesList, numLevels - 1, filter)
                    fun(tabString .. "}")
                else 
                    fun(tabString .. k .. " = -> " .. (tostring(tablesList[v])  or '') .. "--[[" .. str .. "--]],")
                end
            end
        elseif type(v) == "function" then
          fun(tabString .. k .. " = " .. "function() {},")
        elseif type(v) == "string" then
          fun(tabString .. k .. " = '" .. v .. "'")
        else
          fun(tabString .. k .. " = " .. tostring(v) or '' .. ",")
        end
      end        
    end 

    if not _t then 
        fun('traverseTable(): nil value')
        return
    end
    
    if 'table' ~= type(_t) then 
        fun('traverseTable(): not a table', tostring(_t)  or '')
        return
    end
    fun('displaying table:', (tostring(_t) or ''), tostring(_numLevels) or '')
    
    if _numLevels == nil then 
        _numLevels  = math.huge
    end
    
    if (_numLevels <1) then 
        return
    end
    
    if _tabString == nil then
        _tabString = ""
    end
    
    if not _tablesList then 
        _tablesList = {}
    end 
    --fun('_numLevels',_numLevels)
    for k,v in ipairs(filter) do
        print(k,v)
    end
    _traverseTable(_t, _tabString, _tablesList, _numLevels, filter)
    
end